/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.data.gen;

import java.util.Arrays;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;
import tv.mapper.mapperbase.data.gen.BaseLootTables;
import tv.mapper.mapperbase.world.level.block.SlopeBlock;
import tv.mapper.roadstuff.world.item.RSItemRegistry;
import tv.mapper.roadstuff.world.level.block.PaintableRoadBlock;
import tv.mapper.roadstuff.world.level.block.PaintableSlopeBlock;
import tv.mapper.roadstuff.world.level.block.RSBlockRegistry;
import tv.mapper.roadstuff.world.level.block.RotatableSlopeBlock;

public class RSLootTables
extends BaseLootTables {
    public RSLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected void addTables() {
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT_SLOPE.get(), this.createSlopeTable("roadstuff", (Block)RSBlockRegistry.ASPHALT_SLOPE.get(), ((PaintableSlopeBlock)RSBlockRegistry.ASPHALT_SLOPE.get()).getMaterialType()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_SLOPE.get(), this.createSlopeTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_SLOPE.get(), ((PaintableSlopeBlock)RSBlockRegistry.CONCRETE_SLOPE.get()).getMaterialType()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_SLOPE.get(), this.createSlopeTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_SLOPE.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CONCRETE.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_SLAB.get(), this.createSlabTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_SLAB.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_STAIRS.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_STAIRS.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_WALL.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_WALL.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_PRESSURE_PLATE.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_PRESSURE_PLATE.get()));
        this.lootTables.put((Block)RSBlockRegistry.CONCRETE_FENCE.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CONCRETE_FENCE.get()));
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.ASPHALT.get()));
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT_SLOPE.get(), this.createSlopeTable("roadstuff", (Block)RSBlockRegistry.ASPHALT_SLOPE.get()));
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT_SLAB.get(), this.createSlabTable("roadstuff", (Block)RSBlockRegistry.ASPHALT_SLAB.get()));
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT_STAIRS.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.ASPHALT_STAIRS.get()));
        this.lootTables.put((Block)RSBlockRegistry.ASPHALT_PRESSURE_PLATE.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.ASPHALT_PRESSURE_PLATE.get()));
        this.lootTables.put((Block)RSBlockRegistry.BITUMEN_BLOCK.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.BITUMEN_BLOCK.get()));
        this.lootTables.put((Block)RSBlockRegistry.BITUMEN_ORE.get(), this.createSilkTable("roadstuff", (Block)RSBlockRegistry.BITUMEN_ORE.get(), (Item)RSItemRegistry.RAW_BITUMEN.get(), 3, 8, 2));
        for (RegistryObject<Block> object : RSBlockRegistry.MOD_PAINTABLEBLOCKS) {
            Block block = (Block)object.get();
            if (block instanceof RotatableSlopeBlock) {
                this.lootTables.put(block, this.createSlopeTable("roadstuff", block, ((RotatableSlopeBlock)block).getMaterialType()));
                continue;
            }
            this.lootTables.put(block, this.createRoadBlockTable("roadstuff", block, ((PaintableRoadBlock)block).getMaterialType()));
        }
        int i = 0;
        while ((long)i < Arrays.stream(DyeColor.values()).count()) {
            this.lootTables.put((Block)RSBlockRegistry.TRAFFIC_CONE_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.TRAFFIC_CONE_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.TRAFFIC_BARREL_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.TRAFFIC_BARREL_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.TRAFFIC_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.TRAFFIC_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.CYLINDRICAL_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.CYLINDRICAL_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.LUMINESCENT_REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.LUMINESCENT_REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            this.lootTables.put((Block)RSBlockRegistry.GUARDRAIL_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.GUARDRAIL_BLOCKS.get(DyeColor.m_41053_((int)i)).get()));
            ++i;
        }
        this.lootTables.put((Block)RSBlockRegistry.STEEL_GUARDRAIL.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.STEEL_GUARDRAIL.get()));
        this.lootTables.put((Block)RSBlockRegistry.YELLOW_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.YELLOW_BOLLARD.get()));
        this.lootTables.put((Block)RSBlockRegistry.WHITE_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.WHITE_BOLLARD.get()));
        this.lootTables.put((Block)RSBlockRegistry.RED_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.RED_BOLLARD.get()));
        this.lootTables.put((Block)RSBlockRegistry.YELLOW_SMALL_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.YELLOW_SMALL_BOLLARD.get()));
        this.lootTables.put((Block)RSBlockRegistry.WHITE_SMALL_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.WHITE_SMALL_BOLLARD.get()));
        this.lootTables.put((Block)RSBlockRegistry.RED_SMALL_BOLLARD.get(), this.createStandardTable("roadstuff", (Block)RSBlockRegistry.RED_SMALL_BOLLARD.get()));
    }

    protected LootTable.Builder createRoadBlockTable(String modid, Block block, int mat) {
        Block drop = mat == 0 ? (Block)RSBlockRegistry.ASPHALT.get() : (Block)RSBlockRegistry.CONCRETE.get();
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop)).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSlopeTable(String modid, Block block, int mat) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        Block drop = mat == 0 ? (Block)RSBlockRegistry.ASPHALT_SLOPE.get() : (Block)RSBlockRegistry.CONCRETE_SLOPE.get();
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)RSLootTables.withExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SlopeBlock.LAYERS, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SlopeBlock.LAYERS, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SlopeBlock.LAYERS, 4))))));
        return LootTable.m_79147_().m_79161_(builder);
    }
}

